
#version 430 core

layout(location = 0) out float visibility;
  
in vec2 TexCoords;

uniform sampler2D shadow;

uniform bool horizontal;
  
uniform float weight[5] = float[] (0.227027, 0.1945946, 0.1216216, 0.054054, 0.016216);

void main()
{             
	
//do occlusion
     vec2 tex_offset = 1.0 / textureSize(shadow, 0); // gets size of single texel

     float result = texture(shadow, TexCoords).r * weight[0];

	 float originalVisibility = texture(shadow, TexCoords).r * weight[0];

     if(horizontal)
     {
         for(int i = 1; i < 5; ++i)
         {
            result += texture(shadow, TexCoords + vec2(tex_offset.x * i, 0.0)).r * weight[i];
            result += texture(shadow, TexCoords - vec2(tex_offset.x * i, 0.0)).r * weight[i];
         }
     }
	 
     else
     {
         for(int i = 1; i < 5; ++i)
         {
             result += texture(shadow, TexCoords + vec2(0.0, tex_offset.y * i)).r * weight[i];
             result += texture(shadow, TexCoords - vec2(0.0, tex_offset.y * i)).r * weight[i];
         }
     }
	 
	if(originalVisibility < (result)){

     visibility = clamp(result, 0.0, 1.0);
	}
	else{
	visibility = originalVisibility;
	}
	 
	 // / 0.6135132);
}

